/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;

public class SimpleArmorMaterial
implements ArmorMaterial {
    private final int[] durability;
    private final int[] damageReduction;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final LazyLoadedValue<Ingredient> repairMaterial;
    private final String textureName;
    private final float toughness;
    private final float knockbackResistance;

    public SimpleArmorMaterial(int[] durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, Supplier<Ingredient> repairMaterial, String textureName, float toughness, float knockbackResistance) {
        this.durability = durability;
        this.damageReduction = damageReduction;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.repairMaterial = new LazyLoadedValue(repairMaterial);
        this.textureName = textureName;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int m_266425_(ArmorItem.Type type) {
        return this.durability[type.ordinal()];
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReduction[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    public String m_6082_() {
        return this.textureName;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public static class Builder {
        private final int[] durability = new int[4];
        private final int[] damageReduction = new int[4];
        private int enchantability;
        private SoundEvent soundEvent;
        private Supplier<Ingredient> repairMaterial;
        private String textureName;
        private float toughness;
        private float knockbackResistance;

        private Builder() {
        }

        public Builder durability(EquipmentSlot slot, int value) {
            this.durability[slot.m_20749_()] = value;
            return this;
        }

        public Builder durabilityFactor(int factor) {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                this.durability[type.ordinal()] = (Integer)ArmorMaterials.f_266010_.get(type) * factor;
            }
            return this;
        }

        public Builder durability(int[] durability) {
            System.arraycopy(durability, 0, this.durability, 0, 4);
            return this;
        }

        public Builder damageReduction(EquipmentSlot slot, int value) {
            this.damageReduction[slot.m_20749_()] = value;
            return this;
        }

        public Builder damageReduction(int[] damageReduction) {
            System.arraycopy(damageReduction, 0, this.damageReduction, 0, 4);
            return this;
        }

        public Builder enchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder soundEvent(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder repairMaterial(Supplier<Ingredient> repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public Builder textureName(String textureName) {
            this.textureName = textureName;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public SimpleArmorMaterial build() {
            return new SimpleArmorMaterial(this.durability, this.damageReduction, this.enchantability, this.soundEvent, this.repairMaterial, this.textureName, this.toughness, this.knockbackResistance);
        }
    }
}

